% Initial gas loss GUI
%
% Pop-up GUI to insert initial diffusive gas loss conditions for forward
% MDD modeling. This gui can accept 3 stages of initial gas loss that a
% sample may experience prior to diffusion experiment. Only gas loss stages
% that have values other than zero will be used for gas loss calculations
% in the forward MDD model. If the GUI window is canceled the code should
% continue to run without including any inital loss in the forward MDD
% model.
%
%
% This code is provided for the sole purpose of evaluation of an
% accompanying scientific paper preprint entitled ’Diffusion kinetics of
% 3He in pyroxene and plagioclase and applications to cosmogenic exposure
% dating and paleothermometry in mafic rocks’ by Marie Bergelin and three
% other authors. It is not licensed for any other reuse or redistribution.
%
% Written by Marie Bergelin 
% Contact: mbergelin@bgc.org
% Last modified: 2025.02.27

function out = initDiff_GUI

    fw = 550; fh = 250;
    f = uifigure('Position', [450 500 fw fh],'Name','Initial Diffusion steps');

% Box position
efhl = 0.4; eftl = 0.7; efw = 0.1; efh = 0.1;
ef1 = 0.6; ef2 = 0.45; ef3 = 0.3; tw = 0.1; tus = 0.02; 

Ttext= 'Do you want to include inital diffusion steps in the forward MDD model?';

annotation(f,'textbox',[0.05 0.8 0.95 0.1],'String',Ttext,...
            'EdgeColor','none','FontSize',14,...
            'VerticalAlignment','middle','HorizontalAlignment','center');

%%%%% Irradiation

annotation(f,'textbox',[0.1 ef1 0.2 efh],'String','Irradiation',...
            'EdgeColor','none','FontSize',14,...
            'VerticalAlignment','middle');
% Temp1
annotation(f,'textbox',[efhl-tw ef1 tw efh],'String','Temp',...
            'EdgeColor','none','FontSize',14,...
            'VerticalAlignment','middle','HorizontalAlignment','left');
annotation(f,'textbox',[efhl+efw ef1 tw efh],'String',sprintf('^oC'),...
            'EdgeColor','none','FontSize',14,...
            'VerticalAlignment','middle','HorizontalAlignment','left');
% time1
annotation(f,'textbox',[eftl-tw ef1 tw efh],'String',sprintf('time'),...
            'EdgeColor','none','FontSize',14,...
            'VerticalAlignment','middle','HorizontalAlignment','left');

%annotation(f,'textbox',[eftl+efw ef1 tw efh],'String',sprintf('hr'),...
%             'EdgeColor','none','FontSize',14,...
%             'VerticalAlignment','middle','HorizontalAlignment','left');


h1 = uieditfield(f,'numeric','Position',[fw*efhl,fh*ef1,fw*efw,fh*efh],...
                    'HorizontalAlignment','center');
t1 = uieditfield(f,'numeric','Position',[fw*eftl,fh*ef1,fw*efw,fh*efh],...
                    'HorizontalAlignment','center');
u1 = uidropdown(f,'Position',[fw*(eftl+tw+tus),fh*ef1,fw*efw,fh*efh],'FontSize',14,...
                'Items',{'min','hr','day','yr'},'ItemsData',[1 60 1440 525960],...
                'Placeholder','hr','Value',60);

%%%%% Storage

annotation(f,'textbox',[0.1 ef2 0.2 efh],'String','Storage 1',...
            'EdgeColor','none','FontSize',14,...
            'VerticalAlignment','middle');
% Temp2
annotation(f,'textbox',[efhl-tw ef2 tw efh],'String','Temp',...
            'EdgeColor','none','FontSize',14,...
            'VerticalAlignment','middle','HorizontalAlignment','left');
annotation(f,'textbox',[efhl+efw ef2 tw efh],'String',sprintf('^oC'),...
            'EdgeColor','none','FontSize',14,...
            'VerticalAlignment','middle','HorizontalAlignment','left');
% time2
annotation(f,'textbox',[eftl-tw ef2 tw efh],'String',sprintf('time'),...
            'EdgeColor','none','FontSize',14,...
            'VerticalAlignment','middle','HorizontalAlignment','left');
% annotation(f,'textbox',[eftl+efw ef2 tw efh],'String',sprintf('yrs'),...
%             'EdgeColor','none','FontSize',14,...
%             'VerticalAlignment','middle','HorizontalAlignment','left');


h2 = uieditfield(f,'numeric','Value',0,'Position',[fw*efhl,fh*ef2,fw*efw,fh*efh],...
                    'HorizontalAlignment','center');
t2 = uieditfield(f,'numeric','Value',0,'Position',[fw*eftl,fh*ef2,fw*efw,fh*efh],...
                    'HorizontalAlignment','center');
u2 = uidropdown(f,'Position',[fw*(eftl+tw+tus),fh*ef2,fw*efw,fh*efh],'FontSize',14,...
                'Items',{'min','hr','day','yr'},'ItemsData',[1 60 1440 525960],...
                'Placeholder','yr','Value',525960);

% #3
annotation(f,'textbox',[0.1 ef3 0.2 efh],'String','Storage 2',...
            'EdgeColor','none','FontSize',14,...
            'VerticalAlignment','middle');
% Temp3
annotation(f,'textbox',[efhl-tw ef3 tw efh],'String','Temp',...
            'EdgeColor','none','FontSize',14,...
            'VerticalAlignment','middle','HorizontalAlignment','left');
annotation(f,'textbox',[efhl+efw ef3 tw efh],'String',sprintf('^oC'),...
            'EdgeColor','none','FontSize',14,...
            'VerticalAlignment','middle','HorizontalAlignment','left');
% time3
annotation(f,'textbox',[eftl-tw ef3 tw efh],'String',sprintf('time'),...
            'EdgeColor','none','FontSize',14,...
            'VerticalAlignment','middle','HorizontalAlignment','left');
% annotation(f,'textbox',[eftl+efw ef3 tw efh],'String',sprintf('yrs'),...
%             'EdgeColor','none','FontSize',14,...
%             'VerticalAlignment','middle','HorizontalAlignment','left');


h3 = uieditfield(f,'numeric','Value',0,'Position',[fw*efhl,fh*ef3,fw*efw,fh*efh],...
                    'HorizontalAlignment','center');
t3 = uieditfield(f,'numeric','Value',0,'Position',[fw*eftl,fh*ef3,fw*efw,fh*efh],...
                    'HorizontalAlignment','center');
u3 = uidropdown(f,'Position',[fw*(eftl+tw+tus),fh*ef3,fw*efw,fh*efh],'FontSize',14,...
                'Items',{'min','hr','day','yr'},'ItemsData',[1 60 1440 525960],...
                'Placeholder','yr','Value',525960);

% push buttons

uicontrol(f,'Style','Pushbutton','Position',[fw*0.45,fh*0.1,fw*0.1,fh*efh],... % position in the center
                    'String','ok','Callback',@ok);
uicontrol(f,'Style','Pushbutton','Position',[fw*0.85,fh*0.1,fw*0.1,fh*efh],...
                    'String','cancel','Callback',@cancel);

waitfor(f);

    function ok(~,~)

        out.TC = vertcat(get(h1,'Value'),get(h2,'Value'),get(h3,'Value'));
        out.tmin = vertcat((get(t1,'Value')*get(u1,'Value')),(get(t2,'Value')*get(u2,'Value')),(get(t3,'Value')*get(u3,'Value')));
          
        closereq();
    end

    function cancel(~,~)
        out = [];

        closereq();
    end

end